/*!
 * @file        main.h
 *
 * @brief       Header for main.c module
 *
 * @version     V1.0.1
 *
 * @date        2022-02-25
 *
 * @attention
 *
 *  Copyright (C) 2021-2022 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be usefull and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

#ifndef __MAIN_H
#define __MAIN_H

#ifdef __cplusplus
  extern "C" {
#endif

#include "apm32f4xx.h"

#if defined (APM32F407_MINI)

#elif defined (APM32F407_ELE_HUETB)

#elif defined (APM32F407_EVAL)

#define APM_BOARD_COMInit    APM_EVAL_COMInit
#define APM_BOARD_LEDInit    APM_EVAL_LEDInit
#define APM_BOARD_LEDOn      APM_EVAL_LEDOn
#define APM_BOARD_LEDOff     APM_EVAL_LEDOff
#define APM_BOARD_LEDToggle  APM_EVAL_LEDToggle
#define APM_BOARD_PBInit     APM_EVAL_PBInit
#define APM_BOARD_PBGetState APM_EVAL_PBGetState

#else
#error "Please select first the APM32  board to be used (in board.h)"
#endif

#ifdef __cplusplus
}
#endif

#endif /* __MAIN_H */
